
  // Programme de dessin de diagramme HR avec Processing
  //_____________________________________________________________________________________
  // Déclaration des variables
  //_____________________________________________________________________________________
  String Etoiles[], mot[], BV[], M[] ; // Fichier des étoiles, des B-V, des magnitudes
  PFont Verdana ;  // Police de caractères
  float X0, Y0, echellex, echelley ; // Centre du repère et échelle d'affichage en x et en y
  String nomfichier, titrediagramme ;
  //_____________________________________________________________________________________
  // debut du programme
  //_____________________________________________________________________________________
void setup() {
  //_____________________________________________________________________________________
  // Intro
  //_____________________________________________________________________________________
  // Pour choisir entre le diagramme 1 des étoiles brillantes et le 2 dess étoiles proches, deux lignes sont à modifier
  // La ligne nomfichier (mettre "HR1" ou "HR2") et la ligne titrediagramme
  nomfichier="HR2" ; 
  titrediagramme = "Diagramme HR des étoiles situées à moins de 50 parsecs";
  size (1000, 800) ; // taille de la fenêtre d'affichage et du dessin
  background (255); // Fond blanc
  Verdana = loadFont ("Verdana-48.vlw") ; // Il faut que ce fichier Verdana soit disponible
  textFont (Verdana, 12) ; 
  textAlign(CENTER);
  fill(0) ;
  //_____________________________________________________________________________________
  // Mise en place du diagramme
  //_____________________________________________________________________________________
  X0 = 200 ; Y0 = 450 ; echellex = 200 ; echelley = 30 ;
  stroke (0) ;// dessin noir
   textSize(18);
  //text(titrediagramme, 500, 750) ;
  text(titrediagramme, 500, 350) ;
  textSize(12);
  // graduation en x de -0,5 a 3,5
  line (X0-0.5*echellex, Y0+8*echelley, X0+3.5*echellex,Y0+8*echelley) ;
  for(float x = -0.5; x<4 ; x=x+0.5) {
     line(X0+x*echellex, Y0-3+8*echelley, X0+x*echellex, Y0+3+8*echelley) ; 
     text (str(x), X0+x*echellex, Y0+18+8*echelley) ;
  } 
  // graduation en y de 8 a -13
  line (X0-0.5*echellex, Y0+8*echelley, X0-0.5*echellex, Y0-13*echelley) ;
  textAlign(RIGHT);
  for(float y = -13; y<9 ; y=y+1) {
     line(X0-3-0.5*echellex, Y0+y*echelley, X0+3-0.5*echellex, Y0+y*echelley) ; 
     text (str(y), X0-10-0.5*echellex, Y0+y*echelley+2) ;
  } 
  //_____________________________________________________________________________________
  // Lecture du fichier d'étoiles (B-V, M) et affichage des points
  //_____________________________________________________________________________________
  Etoiles = loadStrings(nomfichier+".clea") ; // Charge le fichier HR1. Chaque ligne contient B-V et M pour une étoile séparé d'une espace
  for (int i = 0; i<Etoiles.length; i=i+1) {
    mot = split(Etoiles[i]," "); // Coupe une ligne en deux mots, mot[0] et mot[1] qui sont B-V et M
    //point(X0+echellex*float(mot[0]), Y0+echelley*float(mot[1])) ; 
    ellipse(X0+echellex*float(mot[0]), Y0+echelley*float(mot[1]),1,1) ; 
  } 
  //_____________________________________________________________________________________
  // Enregistrement
  //_____________________________________________________________________________________
  save("dessins/"+nomfichier+".png") ;
}

